#include <iostream>
#include <vector>
#include <algorithm>
#include <map>

using namespace std;

void inicijalizuj_mapu(int k, int l, map<int, int>& polja)
{

    for(int i = 1; i <= k; i++){
        for(int j = 1; j <= l; j++){
            polja[ i * j ] = 0;
        }
    }

    return;
}

void krst(int n, int m, int k, int l, map<int, int>& polja)
{
    int a = (n - 2 * (k - 1));
    int b = (m - 2 * (l - 1));
    polja[k * l] = a * b;

    for(int i = l - 1; i > 0; i--){ // popuni vertikalno
        polja[k * i] += 2 * a;
    }

    for(int i = k - 1; i > 0; i--){ // popuni horizontalno
        polja[l * i] += 2 * b;
    }

}

void kvadrat(int k, int l, map<int, int>& polja)
{

    for(int i = 1; i < k; i++){
        for(int j = 1; j < l; j++){
            polja[ i * j] += 4;  //zbog cetiri pravougaonika
        }
    }
}

int main()
{
  int N, M; cin >> N >> M;
  int K, L; cin >> K >> L;

  vector<int> a;
  int br = N * M;
  for(int i = 0; i < br; i++){
    int x;
    cin >> x;

    a.push_back(x);
  }


    map <int, int> br_ponpolja;

    inicijalizuj_mapu(K, L, br_ponpolja);

    krst(N, M, K, L, br_ponpolja);

    kvadrat(K, L, br_ponpolja);




    sort(a.begin(), a.end());


    long long suma = 0;
    int indeks = 0;

    for(auto it = br_ponpolja.begin(); it != br_ponpolja.end(); it++)
    {
        int br_ponavljanja = it -> first;
        int br_polja = it -> second;

    long long parcijalna = 0;
        for(int i = 0; i < br_polja; i++){
           parcijalna +=  a[indeks + i];
        }

        indeks += br_polja;
        suma += parcijalna * br_ponavljanja;
    }


    cout << suma;


    return 0;
}